* -----------------------------------------------------------------------------
* COBOL-85 Syntax Reference
* COBOL is an acronym that stands for COmmon Business Oriented Language.
* -----------------------------------------------------------------------------
* This file contains an abbreviated COBOL syntax reference for the most
* commonly used COBOL verbs, listed in alphabetical order.
* -----------------------------------------------------------------------------

* These special operand endings have the following meanings:

$i   * uses an alphanumeric data-item
$il  * uses an alphanumeric data-item or a string literal
#i   * uses a numeric data-item
#il  * uses a numeric data-item or numeric literal
$#i  * uses a numeric or an alphanumeric data-item

* Conventions used in COBOL-85 Syntax Reference:

[ X ]      * X is an optional item
{ X } ...  * X may be repeated
{ X | Y }  * Either X or Y is required
arithExp-# * An arithmetic expression 
cName-#    * A condition name (88-level)
cndExp-#   * A conditional expression
id-#       * A data item defined in WORKING-STORAGE
lit-#      * A literal (numeric or alphanumeric, as required)
fName-#    * A logical file name
impStmt-#  * An imperative statement (not IF/EVALUATE)
iName-#    * An index name
libName-#  * A drive:\directory name (C:\MYLIB)
mName-#    * A mnemonic device name (like CONSOLE)
pName-#    * A paragraph name
recName-#  * A record name (FD 01 level id-#)
tName-#    * A physical file name (EXAMPLE.TXT)

ACCEPT id-1 [ FROM { mName-1 | DATE | DAY | DAY-OF-WEEK | TIME } ]

ADD { id-1 | lit-1 } ... TO id-2 [ ROUNDED ] ...
    [ ON SIZE ERROR impstmt-1 ]
    [ NOT ON SIZE ERROR impstmt-2 ]
[ END-ADD ]

ADD { id-1 | lit-1 } ... TO { id-2 | lit-2 }
    GIVING lit-3 [ ROUNDED ] ...
    [ ON SIZE ERROR impStmt-1 ]
    [ NOT ON SIZE ERROR impStmt-2 ]
[ END-ADD ]

CALL { id-1 | lit-1 }
    [ USING { [ BY REFERENCE ] id-2 ... | BY CONTENT id-2 ... } ... ]
    [ ON OVERFLOW impStmt-1 ]
[ END-CALL ]

CLOSE fName-1 ...

COMPUTE id-1 [ ROUNDED ] = arithExp-1
    [ ON SIZE ERROR impstmt-1 ]
    [ NOT ON SIZE ERROR impstmt-2 ]
[ END-COMPUTE ]

COPY tName-1 [ { OF | IN } libName-1 ]
    [ REPLACING { { ==pText-1== | id-1 | lit-1 }
      BY { ==pText-2 | id-2 | lit-2 } } ... ]

DELETE fName-1 RECORD
    [ INVALID KEY impStmt-1 ]
    [ NOT INVALID KEY impStmt-2 ]
[ END-DELETE ]

DISPLAY { id-1 | lit-1 } ... [ UPON mName-1 ] [ WITH NO ADVANCING ]

DIVIDE { id-1 | lit-1 } { INTO | BY } { id-2 | lit-2 }
    GIVING id-3 [ ROUNDED ]
    [ REMAINDER id-4 ]
    [ ON SIZE ERROR impStmt-1 ]
    [ NOT ON SIZE ERROR impStmt-2 ]
[ END-DIVIDE ]

DIVIDE { id-1 | lit-1 } INTO id-2 [ ROUNDED ]
    [ ON SIZE ERROR impStmt-1 ]
    [ NOT ON SIZE ERROR impStmt-2 ]
[ END-DIVIDE ]

EVALUATE { id-1 | lit-1 | arithExp-1 | TRUE | FALSE }
    [ ALSO { id-2 | lit-2 | arithExp-2 | TRUE | FALSE } ]
    { WHEN
        { ANY | cndExp-1 | TRUE | FALSE |
            [ NOT ] { id-3 | lit-3 | arithExp-3 }
            [ THRU  { id-4 | lit-4 | arithExp-4 } ] }
        [ ALSO { ANY | cndExp-2 | TRUE | FALSE |
            [ NOT ] { id-5 | lit-5 | arithExp-5 }
            [ THRU  { id-6 | lit-6 | arithExp-6 } ] } ] ...
        impStmt-1 ... } ...
    [ WHEN OTHER impStmt-2 ... ]
[ END-EVALUATE ]

IF cndExp-1 [ THEN ]
   { stmt-1 ... | NEXT SENTENCE }
[ ELSE
   { stmt-2 ... | NEXT SENTENCE } ]
[ END-IF ]

INITIALIZE id-1 ...

INSPECT id-1 REPLACING
    { CHARACTERS BY { id-2 | lit-1 }
        [ { BEFORE | AFTER } INITIAL { id-3 | lit-2 } ] ... |
    { ALL | LEADING | FIRST } { id-3 | lit-2 } BY { id-4 | lit-3 }
        [ { BEFORE | AFTER } INITIAL { id-5 | lit-4 } ] ... } ... } ...

INSPECT id-1 TALLYING { id-2 FOR
    { CHARACTERS
        [ { BEFORE | AFTER } INITIAL { id-3 | lit-1 } ] ... |
    { ALL | LEADING } { { id-4 | lit-2 }
        [ { BEFORE | AFTER } INITIAL { id-5 | lit-3 } ] ... } ... } ... } ...
    [ REPLACING
        { CHARACTERS BY { id-6 | lit-4 }
            [ { BEFORE | AFTER } INITIAL { id-7 | lit-5 } ] ... |
          { ALL | LEADING | FIRST } { id-7 | lit-4 } BY { id-8 | lit-5 }
            [ { BEFORE | AFTER } INITIAL { id-9 | lit-6 } ] ... } ... } ... ]

INSPECT id-1 CONVERTING { id-2 | lit-1 } TO { id-3 | lit-2 }
    [ { BEFORE | AFTER } INITIAL { id-4 | lit-3 } ] ...

MERGE fName-1 { ON { ASCENDING | DESCENDING } KEY id-1 ... } ...
    [ COLLATING SEQUENCE IS { ASCII | EBCDIC } ]
    USING fName-2 fName-3 ...
    { OUTPUT PROCEDURE IS pName-1 [ THRU pName-2 ] |
      GIVING fName-4 ... }

MOVE { id-1 | lit-1 } TO id-2 ...

MULTIPLY { id-1 | lit-1 } BY id-2 [ ROUNDED ] ...
    [ ON SIZE ERROR impStmt-1 ... ]
    [ NOT ON SIZE ERROR impStmt-2 ... ]
[ END-MULTIPLY ]

MULTIPLY { id-1 | lit-1 } BY { id-2 | lit-2 }
    GIVING id-3 [ ROUNDED ] ...
    [ ON SIZE ERROR impStmt-1 ... ]
    [ NOT ON SIZE ERROR impStmt-2 ... ]
[ END-MULTIPLY ]

OPEN { INPUT fName-1 ... |
       OUTPUT fName-2 ... |
       I-O fName-3 ... |
       EXTEND fName-4 ...} ...

PERFORM [ pName-1 [ THRU pName-2 ] ]
    { { id-1 | lit-1 } TIMES |
      [ WITH TEST { BEFORE | AFTER } ]
      [ VARYING { id-1 | iName-1 }
            FROM { id-2 | iName-2 | lit-1 } BY { id-3 | lit-2 } ]
        UNTIL cndExp-1 }
    [ anyStmt-1 ... END-PERFORM ]

READ fName-1 [ NEXT ] [ INTO id-1 ]
    [ AT END impStmt-1 ... ]
    [ NOT AT END impStmt-2 ... ]
[ END-READ ]

READ fName-1 [ INTO id-1 ]
    [ KEY IS id-2 ]
    [ INVALID KEY impStmt-1 ... ]
    [ NOT INVALID KEY impStmt-2 ... ]
[ END-READ ]

RELEASE recName-1 [ FROM id-2 ]

RETURN fName-1 [ INTO id-1 ]
    AT END impStmt-1 ...
    [ NOT AT END impStmt-2 ... ]
[ END-RETURN ]

REWRITE recName-1 [ FROM id-1 ]

REWRITE recName-1 [ FROM id-1 ]
    [ INVALID KEY impStmt-1 ... ]
    [ NOT INVALID KEY impStmt-2 ... ]
[ END-REWRITE ]

SEARCH id-1 [ VARYING { id-2 | iName-1 }
    [ AT END impStmt-1 ... ]
    { WHEN cndExp-1 { impStmt-2 ... | NEXT SENTENCE } } ...
[ END-SEARCH ]

SEARCH ALL id-1
    [ AT END impStmt-1 ... ]
    WHEN { id-2 = { id-3 | lit-1 | arithExp-1 } | cndExp-1 }
        [ AND { id-4 = { id-5 | lit-2 | arithExp-2 } | cndExp-2 } ] ...
        { impStmt-2 ... | NEXT SENTENCE }
[ END-SEARCH ]

SELECT fname-1
      ASSIGN TO { libName-1 | mName-1 }
    [ ORGANIZATION IS { SEQUENTIAL | INDEXED | DYNAMIC | LINE SEQUENTIAL } ]
    [ ACCESS [ MODE IS ] { SEQUENTIAL | RANDOM | DYNAMIC } ]
    [ RECORD KEY IS id-1 ]
    [ ALTERNATE RECORD KEY IS id-2 ]
    [ FILE STATUS IS id-3 ]

SET { iName-1 | id-1 } ... TO { iName-2 | id-2 | lit-1 }

SET iName-1 ... { UP | DOWN } BY { id-1 | lit-1 }

SET cName-1 ... TO TRUE

SORT fName-1
    { ON { ASCENDING | DESCENDING } KEY { id-1 } ... } ...
    [ WITH DUPLICATES IN ORDER ]
    [ COLLATING SEQUENCE IS { ASCII | EBCDIC } ]
    { INPUT PROCEDURE IS pName-1 [ THRU pName-2 ] |
      USING { fName-2 } ... }
    { OUTPUT PROCEDURE IS pName-3 [ THRU pName-4 ] |
      GIVING { fName-3 } ... }

START fName-1
    [ KEY IS { = | > | NOT < | >= } id-1 }
    [ INVALID KEY { impStmt-1 } ... ]
    [ NOT INVALID KEY { impStmt-2 } ... ]
[ END-START ]

STOP { RUN | lit-1 }

STRING { { id-1 | lit-1 } ... DELIMITED BY { id-2 | lit-2 | SIZE } } ...
    INTO id-3
    [ WITH POINTER id-4 ]
    [ ON OVERFLOW impStmt-1 ... ]
    [ NOT ON OVERFLOW impStmt-2 ... ]
[ END-STRING ]

SUBTRACT { id-1 | lit-1 } ... FROM { id-2 [ ROUNDED ] } ...
    [ ON SIZE ERROR impStmt-1 ... ]
    [ NOT ON SIZE ERROR impStmt-2 ... ]
[ END-SUBTRACT ]

SUBTRACT { id-1 | lit-1 } ... FROM { id-2 | lit-2 }
    GIVING { id-3 [ ROUNDED ] } ...
    [ ON SIZE ERROR impStmt-1 ... ]
    [ NOT ON SIZE ERROR impStmt-2 ... ]
[ END-SUBTRACT ]

UNSTRING id-1
    [ DELIMINTED BY [ ALL ] { id-2 | lit-1 }
        [ OR [ ALL ] { id-3 | lit-2 } ] ... ]
    INTO { id-4
        [ DELIMITER IN id-5 ]
        [ COUNT IN id-6 ] } ...
    [ WITH POINTER id-7 ]
    [ TALLYING IN id-8 ]
    [ ON OVERFLOW impStmt1 ... ]
    [ NOT ON OVERFLOW impStmt2 ... ]
[ END-UNSTRING ]

WRITE recName-1 [ FROM id-1 ]
    [ { BEFORE | AFTER } [ ADVANCING ] { { id-2 | lit-1 } | PAGE } ]
[ END-WRITE ]

WRITE recName-1 [ FROM id-1 ]
    [ INVALID KEY impStmt-1 ... ]
    [ NOT INVALID KEY impStmt-2 ... ]
[ END-WRITE ]
                                                                      


